package Organizer;

import Data.DataPart;
import PrimeNumberCounter.PrimeNumberCounterThread;
import Worker.WorkPartitioner;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

//this class represent one type of the foreman or literally the organizer
//it is the class that organize (split and distribute the data to the workers (threads) and aggregate the results )
public class Organizer_3
{
    public static int Count(int[] data, int threadCount)
    {
        List<PrimeNumberCounterThread> primeNumberCounters = new ArrayList<>();
        List<DataPart> parts = WorkPartitioner.partitions(data.length, threadCount);

        for (int i = 0; i < threadCount; i++)
        {
            primeNumberCounters.add(new PrimeNumberCounterThread(parts.get(i), data));
        }

        ExecutorService executor = Executors.newFixedThreadPool(threadCount);

        for (PrimeNumberCounterThread counter : primeNumberCounters)
        {
            executor.execute(counter);
        }

        executor.shutdown();

        while (!executor.isTerminated())
        {
            //System.out.println("Processing....");
        }

        return primeNumberCounters.stream().mapToInt(PrimeNumberCounterThread::getCount).sum();

    }
}
