package Organizer;

import Data.DataPart;
import PrimeNumberCounter.PrimeNumberCounterRunnable;
import Worker.WorkPartitioner;

import java.util.ArrayList;
import java.util.List;

//this class represent one type of the foreman or literally the organizer
//it is the class that organize (split and distribute the data to the workers (threads) and aggregate the results )
public class Organizer_2
{
    public static int Count(int[] data, int threadCount)
    {
        List<PrimeNumberCounterRunnable> primeNumberCounters = new ArrayList<>();
        List<DataPart> parts = WorkPartitioner.partitions(data.length, threadCount);

        for (int i = 0; i < threadCount; i++)
        {
            primeNumberCounters.add(new PrimeNumberCounterRunnable(parts.get(i), data));
        }

        for (int i = 0; i < threadCount; i++)
        {
            primeNumberCounters.get(i).startThread();
        }

        for (int i = 0; i < threadCount; i++)
        {
            try
            {
                primeNumberCounters.get(i).joinThread();
            }
            catch (InterruptedException e)
            {
                throw new RuntimeException(e);
            }
        }

        int count = 0;
        for (PrimeNumberCounterRunnable primeCounterRunnable : primeNumberCounters)
        {
            count += primeCounterRunnable.getCount();
        }

        return count;

    }
}
