package Organizer;

import Data.DataPart;
import PrimeNumberCounter.PrimeNumberCounterThread;
import Worker.WorkPartitioner;

import java.util.ArrayList;
import java.util.List;

//this class represent one type of the foreman or literally the organizer
//it is the class that organize (split and distribute the data to the workers (threads) and aggregate the results )
public class Organizer_1
{
    public static int Count(int[] data, int threadCount)
    {
        List<PrimeNumberCounterThread> primeNumberCounters = new ArrayList<>();
        List<DataPart> parts = WorkPartitioner.partitions(data.length, threadCount);

        for (int i = 0; i < threadCount; i++)
        {
            primeNumberCounters.add(new PrimeNumberCounterThread(parts.get(i), data));
        }

        for (int i = 0; i < threadCount; i++)
        {
            primeNumberCounters.get(i).start();
        }

        for (int i = 0; i < threadCount; i++)
        {
            try
            {
                primeNumberCounters.get(i).join();
            }
            catch (InterruptedException e)
            {
                throw new RuntimeException(e);
            }
        }

        int count = 0;
        for (PrimeNumberCounterThread primeCounterThread : primeNumberCounters)
        {
            count += primeCounterThread.getCount();
        }

        return count;

    }
}
