package PrimeNumberCounter;

import Data.DataPart;
import Worker.Worker;

//this class is considered as a special type of worker that is used for our program
public class PrimeNumberCounter extends Worker
{
    protected int PrimeNumberCount;

    public PrimeNumberCounter(DataPart part, int[] d)
    {
        super(part, d);
    }

    public int getCount()
    {
        return PrimeNumberCount;
    }

    public static boolean isPrime(int n)
    {
        if (n <= 1)
        {
            return false;
        }
        if (n <= 3)
        {
            return true;
        }
        if (n % 2 == 0 || n % 3 == 0)
        {
            return false;
        }
        for (int i = 5; i * i <= n; i += 6)
        {
            if (n % i == 0 || n % (i + 2) == 0)
            {
                return false;
            }
        }
        return true;
    }

}
