package Worker;

import Data.DataPart;

import java.util.ArrayList;
import java.util.List;

//this class define a tool (method) to partition the data according to the number of the workers (thread)
//which will be used by the organizer (foreman)
public class WorkPartitioner
{
    public static List<DataPart> partitions(int size, int worker_count)
    {
        List<DataPart> parts = new ArrayList<>();
        int part = (int) Math.ceil((double) size / worker_count);
        for (int i = 0; i < worker_count; i++)
        {
            int start = i * part;
            int finish = Math.min((i + 1) * part, size);
            parts.add(new DataPart(start, finish));
        }
        return parts;
    }
}
