public class DescendingHackerThread extends Thread {
    private Vault vault;
    private int attempts;

    public DescendingHackerThread(Vault vault) {
        this.vault = vault;
        this.setName("DescendingHacker");
        this.setPriority(Thread.MAX_PRIORITY);
        this.attempts = 0;
    }

    @Override
    public void run() {
        System.out.println(this.getName() + " started hacking from 9999 to 0");

        // Try every number from 9999 down to 0
        for (int guess = 9999; guess >= 0; guess--) {
            attempts++;
            if (vault.isCorrectPassword(guess)) {
                System.out.println(this.getName() + " cracked the vault! Password: " + guess);
                System.out.println("Total attempts: " + attempts);
                System.exit(0);
            }
        }
        System.out.println(this.getName() + " finished but didn't find the password! Total attempts: " + attempts);
    }
    public int getAttempts() {
        return attempts;
    }
}