public class PoliceThread extends Thread {
    private AscendingHackerThread ascendingHacker;
    private DescendingHackerThread descendingHacker;
    private BinarySearchHackerThread binarySearchHacker;

    public PoliceThread(AscendingHackerThread asc, DescendingHackerThread desc, BinarySearchHackerThread bin) {
        this.setName("Police");
        this.ascendingHacker = asc;
        this.descendingHacker = desc;
        this.binarySearchHacker = bin;
    }

    @Override
    public void run() {
        System.out.println("Police are on the way! 10 seconds remaining...");

        for (int i = 10; i > 0; i--) {
            try {
                Thread.sleep(1000);
                System.out.println(i + " seconds remaining...");
            } catch (InterruptedException e) {
                System.out.println("Police thread was interrupted!");
            }
        }

        System.out.println("Game over for you hackers! Police arrived!");

        System.out.println("Ascending Hacker attempts: " + ascendingHacker.getAttempts());
        System.out.println("Descending Hacker attempts: " + descendingHacker.getAttempts());
        System.out.println("Binary Search Hacker attempts: " + binarySearchHacker.getAttempts());

        System.exit(0);
    }
}