public class BinarySearchHackerThread extends Thread {
    private Vault vault;
    private int attempts;

    public BinarySearchHackerThread(Vault vault) {
        this.vault = vault;
        this.setName("BinarySearchHacker");
        this.setPriority(Thread.MAX_PRIORITY);
        this.attempts = 0;
    }

    @Override
    public void run() {
        System.out.println(this.getName() + " started hacking with REAL binary search algorithm");

        int low = 0;
        int high = 9999;

        while (low <= high) {
            attempts++;
            int mid = low + (high - low) / 2;

            int result = vault.comparePassword(mid);

            if (result == 0) {
                // Password is true
                System.out.println(this.getName() + " cracked the vault! Password: " + mid);
                System.out.println("Total attempts: " + attempts);
                System.exit(0);
            } else if (result == -1) {
                // less than password
                low = mid + 1;
            } else {
                // bigger than Password
                high = mid - 1;
            }
        }
        System.out.println(this.getName() + " finished! Total attempts: " + attempts);
    }
    public int getAttempts() {
        return attempts;
    }
}