public class AscendingHackerThread extends Thread {
    private Vault vault;
    private int attempts;

    public AscendingHackerThread(Vault vault) {
        this.vault = vault;  // Store the vault reference
        this.setName("AscendingHacker");  // Give this thread a clear name
        this.setPriority(Thread.MAX_PRIORITY);  // Give high priority
        this.attempts = 0;
    }

    @Override
    public void run() {
        System.out.println(this.getName() + " started hacking from 0 to 9999");

        // Try every number from 0 to 9999
        for (int guess = 0; guess < 10000; guess++) {
            // Check if this guess is correct
            attempts++;
            if (vault.isCorrectPassword(guess)) {
                System.out.println(this.getName() + " cracked the vault! Password: " + guess);
                System.out.println("Total attempts: " + attempts);
                System.exit(0);  // End the entire program
            }
        }

        // If we get here, we didn't find the password
        System.out.println(this.getName() + " finished but didn't find the password! Total attempts: " + attempts);
    }

    public int getAttempts() {
        return attempts;
    }

}