package org.example;

import com.google.protobuf.InvalidProtocolBufferException;
import org.ds.proto.Author;
import org.ds.proto.Book;
import org.ds.proto.BookType;
import org.ds.proto.Library;

public class Main {
    public static void main(String[] args) throws InvalidProtocolBufferException {
        byte[] msg = sender();
        receiver(msg);
    }

    private static void receiver(byte[] msg) throws InvalidProtocolBufferException {
        System.out.println("Received Data:");
        // Display binary data
        for (int i = 0; i < msg.length; i++) {
            System.out.print(msg[i] + " ");
        }
        System.out.println();
        System.out.println("Total bytes: " + msg.length);

        // Deserialize
        var library = Library.parseFrom(msg);
        System.out.println("Library contents:");
        System.out.println(library.getBooksList());

        // Display detailed book information
        System.out.println("\nDetailed Book Information:");
        for (Book book : library.getBooksList()) {
            System.out.println("Title: " + book.getTitle());
            System.out.println("Author: " + book.getAuthor().getName() + " from " + book.getAuthor().getCountry());
            System.out.println("ISBN: " + book.getIsbn());
            System.out.println("Year: " + book.getYear());
            System.out.println("Type: " + book.getType());
            System.out.println("Categories: " + book.getCategoriesList());
            System.out.println("Available: " + book.getAvailable());
            System.out.println("---");
        }
    }

    private static byte[] sender() {
        // Create first book
        Book book1 = Book.newBuilder()
                .setTitle("Protocol Buffers in Distributed Systems")
                .setAuthor(Author.newBuilder()
                        .setName("Ahmed Networks")
                        .setCountry("Egypt")
                        .build())
                .setIsbn("978-1234567890")
                .setYear(2024)
                .setType(BookType.TECHNICAL)
                .addCategories("Networks")
                .addCategories("Programming")
                .setAvailable(true)
                .build();

        // Create second book
        Book book2 = Book.newBuilder()
                .setTitle("gRPC Fundamentals and Communications")
                .setAuthor(Author.newBuilder()
                        .setName("Mohamed Developer")
                        .setCountry("Saudi Arabia")
                        .build())
                .setIsbn("978-0987654321")
                .setYear(2023)
                .setType(BookType.SCIENCE)
                .addCategories("Communications")
                .addCategories("API")
                .setAvailable(true)
                .build();

        // Create library and add books
        Library library = Library.newBuilder()
                .addBooks(book1)
                .addBooks(book2)
                .build();

        // Serialize to byte array
        byte[] arrayToSend = library.toByteArray();

        // Display sent data
        System.out.println(" Sent Data:");
        for (int i = 0; i < arrayToSend.length; i++) {
            System.out.print(arrayToSend[i] + " ");
        }
        System.out.println();
        System.out.println(" Total bytes to send: " + arrayToSend.length);

        return arrayToSend;
    }
}