package consumer;

public class EncryptionProcessor {
    private final int shiftKey;

    public EncryptionProcessor(int shiftKey) {
        this.shiftKey = shiftKey;
    }

    public String processLine(String line) {
        // Handle empty or null lines
        if (line == null || line.trim().isEmpty()) {
            return line;
        }

        return caesarCipher(line, shiftKey);
    }

    private String caesarCipher(String text, int shift) {
        StringBuilder result = new StringBuilder();

        for (char character : text.toCharArray()) {
            if (Character.isLetter(character)) {
                // Determine if uppercase or lowercase
                char base = Character.isLowerCase(character) ? 'a' : 'A';
                // Calculate new position with wrap-around
                int originalPosition = character - base;
                int newPosition = (originalPosition + shift) % 26;
                // Handle negative shifts
                if (newPosition < 0) {
                    newPosition += 26;
                }
                char encryptedChar = (char) (base + newPosition);
                result.append(encryptedChar);
            } else {
                // Keep non-letter characters unchanged
                result.append(character);
            }
        }

        return result.toString();
    }

    public int getShiftKey() {
        return shiftKey;
    }
}