package model;

public class SequencedLine implements Comparable<SequencedLine> {
    private final int sequenceNumber;
    private final String line;

    public SequencedLine(int sequenceNumber, String line) {
        this.sequenceNumber = sequenceNumber;
        this.line = line;
    }

    public int getSequenceNumber() {
        return sequenceNumber;
    }

    public String getLine() {
        return line;
    }

    /**
     * Defines the natural ordering of SequencedLine objects
     * Lines with lower sequence numbers have higher priority
     */
    @Override
    public int compareTo(SequencedLine other) {
        return Integer.compare(this.sequenceNumber, other.sequenceNumber);
    }

    @Override
    public String toString() {
        return "SequencedLine{sequence=" + sequenceNumber + ", line='" + line + "'}";
    }
}