# Parallel Encryption System

## Description
A Java-based parallel file encryption system that demonstrates thread synchronization concepts. The system reads text files, encrypts them using Caesar cipher, and maintains line order through concurrent processing.

## Features
- Parallel processing with configurable number of consumer threads
- Caesar cipher encryption with customizable shift key
- Thread-safe ordered processing using PriorityBlockingQueue
- Producer-consumer pattern implementation
- Maintains original file line order in output
- Progress reporting during processing

## Prerequisites
- Java 17 or higher
- Maven 3.6 or higher

## Building the Project
```bash
mvn clean compile
```

## Running the Application
Compile and run the application:
```bash
mvn clean package
java -cp target/classes Main
```

## Usage
The application will prompt for configuration:

1. **Input file**: Path to the text file to encrypt (default: input.txt)
2. **Output file**: Path for the encrypted output (default: output.txt)
3. **Number of consumers**: Number of parallel encryption threads (default: 3)
4. **Encryption key**: Caesar cipher shift value (default: 3)

Example interaction:
```
Input file (default: input.txt): myfile.txt
Output file (default: output.txt): encrypted.txt
Number of consumers (default: 3): 5
Encryption key (default: 3): 7
```

## Architecture
The system uses a producer-consumer pattern with three main components:

- **Producer**: Reads input file line by line, assigns sequence numbers, and places lines in a priority queue
- **Consumers**: Multiple threads that encrypt lines using Caesar cipher and place results in output queue
- **Writer**: Single thread that writes encrypted lines to output file in correct order

Thread synchronization is achieved through:
- `PriorityBlockingQueue` for ordered, thread-safe queues
- `AtomicBoolean` for production completion signaling
- `AtomicInteger` for tracking active consumers

