# Leader Election with Advancing Smart Watching

## Overview
This project implements a leader election algorithm using Apache ZooKeeper. The "advancing smart watching" approach optimizes the traditional leader election by having each participant node watch only the immediately preceding node in the sorted list of candidates. This reduces unnecessary notifications and improves scalability in distributed systems.

## How It Works
1. **Node Registration**: Each participant creates an ephemeral sequential znode under the `/election` namespace.
2. **Sorting and Leader Determination**: Nodes are sorted lexicographically, and the smallest znode becomes the leader.
3. **Smart Watching**: Non-leader nodes watch only the previous node in the sorted list.
4. **Re-election Trigger**: When a watched node is deleted (due to node failure or disconnection), the watcher triggers a re-election process.

## Improvements with Smart Watching
- **Reduced Network Traffic**: Instead of watching all nodes or constantly polling, each node monitors only one predecessor, minimizing ZooKeeper notifications.
- **Scalability**: The algorithm scales better with increasing numbers of participants, as the number of watches remains proportional to the number of nodes.
- **Efficiency**: Faster re-election upon node failures, as only affected nodes need to update their watches.
- **Fault Tolerance**: Leverages ZooKeeper's ephemeral znodes to automatically handle node disconnections.

## Usage
1. Ensure ZooKeeper is running on the specified address (default: 192.168.97.15:2181).
2. Compile and run the `LeaderElection.java` class.
3. Multiple instances can be started to simulate a distributed environment.

## Dependencies
- Apache ZooKeeper (version compatible with the ZooKeeper Java client)
- Java 8 or higher

## Building and Running
```bash
mvn clean compile
java -cp target/classes LeaderElection
```

## Configuration
- ZooKeeper address: Modify the `address` constant in `LeaderElection.java`
- Session timeout: Adjust `SESSION_TIMEOUT` as needed
- Election namespace: Change `ELECTION_NAMESPACE` if required
