package com.distributed.search.logic;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class FileManager {

    public static List<String> getSortedDocumentNames(String directoryPath) {
        File directory = new File(directoryPath);
        File[] files = directory.listFiles(File::isFile);

        if (files == null) return List.of();

        return Arrays.stream(files)
                .map(File::getName)
                .sorted()
                .collect(Collectors.toList());
    }

    public static String readDocumentContent(String directoryPath, String fileName) throws IOException {
        return Files.readString(Paths.get(directoryPath, fileName));
    }
}