package org.example.client;

import org.example.shared.IClientCallback;
import org.example.shared.IQuizService;

import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.Scanner;

public class QuizClient {

    public static void main(String[] args) {
        try {
            Scanner scanner = new Scanner(System.in);

            Registry registry = LocateRegistry.getRegistry("localhost", 1099);

            IQuizService server = (IQuizService) registry.lookup("QuizService");

            System.out.print("Enter your name to join the quiz: ");
            String name = scanner.nextLine().trim();

            IClientCallback clientCallback = new ClientCallbackImpl();
            server.login(name, clientCallback);

            System.out.println("Connected successfully! Welcome, " + name);

            boolean running = true;
            while (running) {
                System.out.println("\n--- Menu ---");
                System.out.println("1. Get a Random Question");
                System.out.println("2. Exit");
                System.out.print("Choose an option: ");

                String choice = scanner.nextLine();

                switch (choice) {
                    case "1":
                        String question = server.getQuestion();
                        System.out.println("\n- Question: " + question);

                        System.out.print("- Your Answer: ");
                        String answer = scanner.nextLine();

                        String feedback = server.submitAnswer(name, question, answer);
                        System.out.println("- Result: " + feedback);
                        break;

                    case "2":
                        running = false;
                        System.out.println("Exiting... Goodbye!");
                        System.exit(0);
                        break;

                    default:
                        System.out.println("Invalid option. Please try again.");
                }
            }

        } catch (Exception e) {
            System.err.println("Client exception: " + e.toString());
            e.printStackTrace();
        }
    }
}