# Distributed Quiz System using Java RMI

A distributed quiz application built with **Java Remote Method Invocation (RMI)**. The system allows multiple students (clients) to connect to a central server, answer random questions, receive immediate feedback, and view a real-time leaderboard.

##  Project Overview

This project demonstrates the implementation of a distributed system where:
- **The Server** manages the quiz logic, stores questions, tracks student scores, and persists data.
- **The Client** connects remotely to request questions and submit answers.
- **Callbacks** are used by the server to push updates (Leaderboard) to connected clients asynchronously.

##  Features

- **Client-Server Architecture:** Built using Java RMI.
- **Randomized Questions:** Clients receive random questions from the server's pool.
- **Real-time Feedback:** Immediate validation of answers (Correct/Wrong) with score updates.
- **Live Leaderboard:** The server broadcasts the "Top 3 Students" to all connected clients periodically using **RMI Callbacks**.
- **Data Persistence:** Student scores are automatically saved to a file (`scores.dat`) when the server shuts down and reloaded upon restart.
- **Concurrent Users:** Supports multiple students playing simultaneously.

##  Technologies Used

- **Language:** Java (JDK 8+)
- **Communication:** Java RMI (Remote Method Invocation)
- **Data Structure:** `HashMap` for storing scores, `ArrayList` for questions.
- **Persistence:** `ObjectOutputStream` (Serialization).

##  Project Structure

```text
src/main/java/org/example
├── client
│   ├── QuizClient.java          # Main client entry point
│   └── ClientCallbackImpl.java  # Callback implementation for server notifications
├── server
│   ├── QuizServer.java          # Main server entry point (Registry setup)
│   └── QuizServiceImpl.java     # Core logic (Questions, Scoring, Persistence)
└── shared
    ├── IQuizService.java        # Interface for Server methods
    └── IClientCallback.java     # Interface for Client callback methods
```
## How to Run

### Prerequisites
*   **Java Development Kit (JDK)** installed.
*   An IDE (IntelliJ IDEA, Eclipse) or Terminal.

### Step 1: Start the Server
1.  Navigate to the file: `org.example.server.QuizServer`.
2.  Run the `main` method.
3.  The console will show:
    ```text
    Quiz Server is running and ready...
    ```
    > **Note:** The server automatically starts the RMI Registry on port `1099`.

### Step 2: Start the Client(s)
1.  Navigate to the file: `org.example.client.QuizClient`.
2.  Run the `main` method.
3.  Enter your **name** when prompted.
4.  Use the menu to request questions.
5.  *Optional: Run multiple instances of `QuizClient` to simulate multiple students.*

## 💾 Data Persistence

The system ensures that student progress is not lost:

*   **Saving:** When the server is stopped (via `SIGINT` or the IDE's **Stop** button), a **Shutdown Hook** triggers to serialize the scores `HashMap` into a `scores.dat` file.
*   **Loading:** Upon restarting, the server looks for `scores.dat` to restore previous scores.

## 📝 Usage Example

```text
--- Menu ---
1. Get a Random Question
2. Exit
Choose an option: 1

❓ Question: What is 1 + 1?
✍️ Your Answer: 2
📝 Result: Correct Answer! (+10 points) | Total Score: 10

... (After 30 seconds) ...

================================
📢 Notification from Server:
--- Leaderboard Top 3 ---
Ali: 50
Sara: 30
Ahmed: 10
-----------------------
================================