package org.example.server;

import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;

public class QuizServer {

    public static void main(String[] args) {
        try {
            QuizServiceImpl quizService = new QuizServiceImpl();

            Registry registry = LocateRegistry.createRegistry(1099);

            registry.rebind("QuizService", quizService);
            System.out.println("Quiz Server is running and ready...");

            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                System.out.println("\nServer is shutting down...");
                quizService.saveScoresToFile();
            }));

        } catch (Exception e) {
            System.err.println("Server exception: " + e.toString());
            e.printStackTrace();
        }
    }
}