# Distributed Calculator System

A distributed calculator system built with gRPC and multiple programming languages. This project demonstrates microservices architecture with three independent services communicating via gRPC.

## Prerequisites

- **Python 3.11+** (Client Gateway)
- **Go 1.21+** (Addition Service) 
- **Node.js 18+** (Multiplication Service)
- **Protocol Buffers Compiler (protoc)**

## Quick Start

### 1. Clone the repository
```bash
git clone <repository-url>
cd distributed-calculator
```

## How to Run Each Service

- **Addition Service (Go)**
  - Navigate to the service directory: `cd addition-service`
  - Download dependencies: `go mod download`
  - Run the service: `go run main.go`
  - Expected Output:
    ```
    Addition Service running on port 50052
    Ready to receive addition requests...
    ```

- **Multiplication Service (Node.js)**
  - Navigate to the service directory: `cd multiplication-service`
  - Install dependencies: `npm install`
  - Run the service: `npm start`
  - Expected Output:
    ```
    Multiplication Service (Node.js) running on port 50053
    Ready to receive multiplication requests...
    Powered by Node.js
    ```

- **Client Gateway (Python)**
  - Navigate to the gateway directory: `cd client-gateway`
  - Install dependencies: `pip install grpcio grpcio-tools`
  - Run the gateway: `python client_gateway.py`
  - Expected Output:
    ```
    Distributed Calculator System
    1. Perform calculations
    2. Show operation history
    3. Exit
    Choose option:
    ```

## How to Test the Connection Between Services

- After running all services, you can test the connection between them by using the client gateway to perform calculations.
- When choosing "Perform calculations", you will need to enter the type of operation (add or multiply) and the values.
- If the services are working correctly, the gateway will send a request to the appropriate service and return the result.

## Example Input and Output

- **Input:**
  ```
  Choose option: 1
  Enter first number: 2
  Enter second number: 3
  ```

- **Output 1:**
  ```
  Distributed Calculator System
  1. Perform calculations
  2. Show operation history
  3. Exit
  Choose option: 1
  Enter first number: 2
  Enter second number: 3
  Addition: 2 + 3 = 5
  Multiplication: 2 × 3 = 6
  ```

- **Input 2:**
  ```
  Choose option: 2
  ```

- **Output:**
  ```
  Distributed Calculator System
  1. Perform calculations
  2. Show operation history
  3. Exit
  Choose option: 2

  Fetching operation history...

  Addition Operation History:
    [Timestamp]: 2 + 3 = 5

  Multiplication Operation History:
    [Timestamp]: 2 × 3 = 6
  ```

- **Input 3:**
  ```
  Choose option: 3
  ```

- **Output:**
  ```
  Choose option: 3
  Goodbye!
  ```
