# Linux Scripts Repository

Welcome to the Linux Scripts Repository! This repository is designed to help HIAST students share and learn from each other's Linux scripts. Whether you are just starting out or have been scripting for a while, your contributions are valuable.

## Table of Contents

- [Getting Started](#getting-started)
- [How to Contribute](#how-to-contribute)
- [Submission Guidelines](#submission-guidelines)
- [License](#license)
- [Contact](#contact)

## Getting Started

To get started, you need to have Git installed on your local machine. If you don't have Git installed, you can download it from [here](https://git-scm.com/downloads).



## How to Contribute

1. **Fork the repository**: Click the "Fork" button at the top right corner of the repository page on GitLab. This will create a copy of the repository in your GitLab account.

2. **Clone your fork**: Clone your forked repository to your local machine.

    ```bash
    git clone https://git.hiast.edu.sy/yourusername/linux-scripts.git
    cd linux-scripts
    ```

3. **Create a new branch**: Create a new branch for your script.

    ```bash
    git checkout -b add-your-script
    ```

4. **Create a folder for the current term**: If it doesn't already exist, create a folder for the current term (e.g., `2024`).

    ```bash
    mkdir -p 2024
    ```

5. **Create your personal folder**: Within the current term folder, create a folder with your name.

    ```bash
    mkdir -p 2024/your_name
    ```

6. **Add your script**: Create your script file within your personal folder. Please follow the naming convention `your_script_name.sh`.

    ```bash
    touch 2024/your_name/your_script_name.sh
    ```

7. **Write your script**: Open the file in your preferred text editor and write your script. Ensure your script is executable.

    ```bash
    chmod +x 2024/your_name/your_script_name.sh
    ```

8. **Commit your changes**: Commit your changes with a meaningful message.

    ```bash
    git add 2024/your_name/your_script_name.sh
    git commit -m "Add script to [describe the functionality]"
    ```

9. **Push to GitLab**: Push your changes to your forked repository.

    ```bash
    git push origin add-your-script
    ```

10. **Create a Merge Request**: Go to the original repository on GitLab and create a Merge Request from your forked repository. Provide a detailed description of your script and what it does.

## Submission Guidelines

- **Script Naming**: Use descriptive names for your scripts to make it clear what they do.
- **Comments**: Add comments to your script to explain the purpose of each section or command.
- **Permissions**: Ensure your script is executable (`chmod +x your_script_name.sh`).
- **Documentation**: Include a brief documentation or usage guide at the top of your script.
- **Test Your Script**: Make sure your script runs without errors before submitting.

## License

By contributing to this repository, you agree that your contributions will be licensed under the MIT License.

## Contact

If you have any questions or need help, feel free to contact at [mohamadbashar.disoki@hiast.edu.sy].

Happy Scripting!
