import java.util.ArrayList;
import java.util.List;
public class ThreadPool {

    // Declare variables
    private SynchronizedQueue<Runnable> taskQueue = null;
    private List<PoolThreadRunnable> runnables = new ArrayList<>();
    private boolean isStopped = false;

    // Constructor for ThreadPool class
    public ThreadPool(int noOfThreads, int maxNoOfTasks){

        // Initialize the task queue with the maximum number of tasks
        taskQueue = new SynchronizedQueue<Runnable> (maxNoOfTasks);

        // Create the specified number of threads and add them to the list of runnables
        for(int i=0; i<noOfThreads; i++){
            PoolThreadRunnable poolThreadRunnable =
                    new PoolThreadRunnable(taskQueue);

            runnables.add(poolThreadRunnable);
        }

        // Start each thread in the list of runnables
        for(PoolThreadRunnable runnable : runnables){
            new Thread(runnable).start();
        }
    }

    // Method to add a task to the task queue
    public synchronized void  execute(Runnable task) throws Exception{
        if(this.isStopped) throw
                new IllegalStateException("ThreadPool is stopped");

        // Add the task to the task queue
        this.taskQueue.offer(task);
    }

    // Method to stop all threads in the thread pool
    public synchronized void stop(){
        this.isStopped = true;
        for(PoolThreadRunnable runnable : runnables){
            runnable.doStop();
        }
    }

    // Method to wait until all tasks in the task queue have been completed
    public synchronized void waitUntilAllTasksFinished() {
        while(this.taskQueue.size() > 0) {
            try {
                Thread.sleep(1);
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

}
