public class ThreadPoolMain {

    public static void main(String[] args) throws Exception {

        // Create a thread pool with 3 threads and a maximum of 10 tasks
        ThreadPool threadPool = new ThreadPool(3, 100);

        // Execute 10 tasks
        for(int i=0; i<1000; i++) {

            int taskNo = i;

            // Execute each task in a lambda expression
            threadPool.execute( () -> {
                String message =
                        Thread.currentThread().getName()
                                + ": Task " + taskNo ;
                System.out.println(message);
            });
        }

        // Wait until all tasks in the thread pool have finished
        threadPool.waitUntilAllTasksFinished();

        // Stop the thread pool and its threads
        threadPool.stop();

    }
}
