
public class PoolThreadRunnable implements Runnable {

    // Declare variables
    private Thread thread = null;
    private SynchronizedQueue<Runnable> taskQueue = null;
    private boolean isStopped = false;

    // Constructor for PoolThreadRunnable class
    public PoolThreadRunnable(SynchronizedQueue<Runnable> queue){
        taskQueue = queue;
    }

    // Method to run the thread
    public void run(){

        // Set the current thread to the thread variable
        this.thread = Thread.currentThread();

        // Keep the thread running until it is stopped
        while(!isStopped()){

            try{
                // Get the next task from the task queue and run it
                Runnable runnable = (Runnable) taskQueue.take();
                runnable.run();

            } catch(Exception e){
                // Log or otherwise report exception,
                // but keep pool thread alive.
            }
        }
    }

    // Method to stop the thread
    public synchronized void doStop(){
        isStopped = true;

        // Interrupt the thread to break it out of the dequeue() call
        this.thread.interrupt();
    }

    // Method to check if the thread is stopped
    public synchronized boolean isStopped(){
        return isStopped;
    }
}
