import java.util.LinkedList;
import java.util.Queue;

public class SynchronizedQueue<T> {
    private Queue<T> queue = new LinkedList<>();

    int maxSize;

    // Constructor for SynchronizedQueue class
    public SynchronizedQueue(int maxSize) {
        this.maxSize=maxSize;
    }

    // Method to add an element to the queue
    public synchronized void offer(T element) {

        // Wait until the queue is not full
        while (maxSize == queue.size()) {
            try {
                wait();
            } catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }

        // Add the element to the queue
        queue.offer(element);

        // Notify all waiting threads that an element has been added
        notifyAll();
    }

    // Method to take an element from the queue
    public synchronized T take() throws InterruptedException {

        // Wait until the queue is not empty
        while (queue.isEmpty()) {
            wait();
        }

        // Remove and return the element from the queue
        return queue.poll();
    }

    // Method to get the size of the queue
    public synchronized int size() {
        return queue.size();
    }
}
