import java.util.ArrayList;
import java.util.List;

public class PrimeNumberGenerator implements Runnable{

    public PrimeNumberGenerator(int rangeStart, int rangeEnd) {
        this.setRangeStart(rangeStart);
        this.setRangeEnd(rangeEnd);
        generatedPrimeNumbers = new ArrayList<Integer>();
    }

    public PrimeNumberGenerator() {

    }

    public int getRangeStart() {
        return rangeStart;
    }

    public int getRangeEnd() {
        return rangeEnd;
    }

    public void setRangeStart(int rangeStart) {
        this.rangeStart = rangeStart;
    }

    public void setRangeEnd(int rangeEnd) {
        this.rangeEnd = rangeEnd;
    }

    public List<Integer> getGeneratedPrimeNumbers() {
        return generatedPrimeNumbers;
    }

    public boolean checkPrime(int number){
        if(number <= 1) return false;
        else if (number == 2) return true;
        else{
            for(int i = 2 ; i <= Math.sqrt(number) ; i++){
                if(number % i == 0){
                    return false;
                }
            }
            return true;
        }
    }

    private int rangeStart;
    private int rangeEnd;
    private List<Integer> generatedPrimeNumbers;


    @Override
    public void run() {
        int i = this.getRangeStart();
        for( ; i < this.getRangeEnd() ; i++){
            if(this.checkPrime(i)) generatedPrimeNumbers.add(i);
        }
    }
}
