import java.util.ArrayList;
import java.util.List;

public class Main {
    public static void main(String[] args) throws InterruptedException {

        int rangeStart = 1;
        int rangeEnd = 100_000_000;
        int threadsNumber = 4;
        int partialRange = (rangeEnd-rangeStart)/threadsNumber;
        List<PrimeNumberGenerator> primeNumberGeneratorList = new ArrayList<PrimeNumberGenerator>();
        List<Thread> threadList = new ArrayList<Thread>();
        List<Integer> primeNumbers = new ArrayList<Integer>();

        for(int i = 0 ; i<threadsNumber ; i++){
            int partialRangeStart = rangeStart + partialRange* i;
            int partialRangeEnd = partialRangeStart + partialRange - 1;
            PrimeNumberGenerator primeNumberGenerator = new PrimeNumberGenerator(partialRangeStart,partialRangeEnd);
            Thread thread = new Thread(primeNumberGenerator);
            threadList.add(thread);
            primeNumberGeneratorList.add(primeNumberGenerator);
            thread.start();
        }
        long startTime = System.currentTimeMillis();

        for (Thread thread : threadList) {
            thread.join();
        }

        long endTime = System.currentTimeMillis();

        for (PrimeNumberGenerator primeNumberGenerator : primeNumberGeneratorList) {
            primeNumbers.addAll(primeNumberGenerator.getGeneratedPrimeNumbers());
        }

        System.out.println("Number of prime numbers found: " + primeNumbers.size());
        System.out.println("Execution time: " + (endTime - startTime) + " milliseconds");
    }
}
