import static org.junit.jupiter.api.Assertions.*;
import org.PrimeProj.ParallelCounters.*;
import org.PrimeProj.SequentialCounter;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class ParallelCountersTest {
    private static int rangeStart;
    private static int rangeEnd;
    private static long result;

    @BeforeAll
    public static void initialize() {
        rangeStart = 0;
        rangeEnd = 100000;
        result = SequentialCounter.countPrimes(rangeStart,rangeEnd);
    }

    private static void testAll(int threadCount) {
        assertEquals(result, ParallelCounter0.countPrimes(rangeStart,rangeEnd,threadCount));
        assertEquals(result, ParallelCounter1.countPrimes(rangeStart,rangeEnd,threadCount));
        assertEquals(result, ParallelCounter2.countPrimes(rangeStart,rangeEnd,threadCount));
        assertEquals(result, ParallelCounter3.countPrimes(rangeStart,rangeEnd,threadCount));
        assertEquals(result, ParallelCounter4.countPrimes(rangeStart,rangeEnd,threadCount));
    }

    @Test
    void testSingleThread() {
        testAll(1);
    }

    @Test
    void testTwoThread() {
        testAll(2);
    }

    @Test
    void testFourThread() {
        testAll(4);
    }

    @Test
    void testEightThread() {
        testAll(8);
    }

    @Test
    void testSixteenThread() {
        testAll(16);
    }

}
