package org.PrimeProj.ParallelCounters;

import org.PrimeProj.Counters.CounterCallable;
import org.PrimeProj.Worker.WorkPartitioner;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

// This class calculates the number of prime numbers using CounterThread and ExecutorService
// with a fixed thread  pool. The class submits the threads one bye one for executions.


public class ParallelCounter4 {
    public static long countPrimes(int rangeStart, int rangeFinish, int threadCount) {

        //creating a pool of 5 threads
        ExecutorService executor = Executors.newFixedThreadPool(threadCount);
        List<Future<Long>> results = new ArrayList<Future<Long>>();
        int range = rangeFinish - rangeStart + 1;
        List<WorkPartitioner.Part> parts =  WorkPartitioner.partitions(range, threadCount);

        for (WorkPartitioner.Part part : parts) {
            results.add(executor.submit(new CounterCallable(part)));
        }

        executor.shutdown();

        while (!executor.isTerminated()) {
            //System.out.println("Processing...");
        }

        long count = 0;
        for (Future<Long> future : results) {
            try {
                count += future.get();
            } catch (InterruptedException | ExecutionException e) {
                System.err.println("Cannot get the results from threads.");
                return -2;
            }
        }

        return count;
    }

}
