package org.PrimeProj.ParallelCounters;

import org.PrimeProj.Counters.CounterCallable;
import org.PrimeProj.Worker.WorkPartitioner;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

// This class calculates the number of prime numbers using CounterCallable and ExecutorService
// with a fixed thread  pool. The class invokes all the callables at once.

public class ParallelCounter3 {
    public static long countPrimes(int rangeStart, int rangeFinish, int threadCount) {

        //creating a pool of #threadCount threads
        ExecutorService executor = Executors.newFixedThreadPool(threadCount);

        List<CounterCallable> counters =  new ArrayList<CounterCallable>();
        int range = rangeFinish - rangeStart + 1;
        List<WorkPartitioner.Part> parts =  WorkPartitioner.partitions(range, threadCount);

        for (WorkPartitioner.Part part : parts) {
            counters.add(new CounterCallable(part));
        }

        List<Future<Long>> results;
        try {
            results = executor.invokeAll(counters);
        } catch (InterruptedException e) {
            System.err.println("Cannot invoke the threads.");
            return -1;
        }

        executor.shutdown();

        long count = 0;
        for (Future<Long> future : results) {
            try {
                count += future.get();
            } catch (InterruptedException | ExecutionException e) {
                System.err.println("Cannot get the results from threads.");
                return -2;
            }
        }
        return count;
    }

}
