package org.PrimeProj.ParallelCounters;

import org.PrimeProj.Counters.CounterThread;
import org.PrimeProj.Worker.WorkPartitioner;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

//This class calculates the number of prime numbers using CounterThread and ExecutorService
//with a fixed thread  pool. The class executes the threads one bye one.

public class ParallelCounter2 {
    public static long countPrimes(int rangeStart, int rangeFinish, int threadCount) {

        List<CounterThread> counters =  new ArrayList<>();
        int range = rangeFinish - rangeStart + 1;
        List<WorkPartitioner.Part> parts =  WorkPartitioner.partitions(range, threadCount);

        for (WorkPartitioner.Part part : parts) {
            counters.add(new CounterThread(part));
        }

        //creating a pool of 5 threads
        ExecutorService executor = Executors.newFixedThreadPool(threadCount);

        for (CounterThread counter: counters) {
            executor.execute(counter);
        }

        executor.shutdown();

        //Waiting for all the thread to finalize
        while (!executor.isTerminated()) {
            //System.out.println("Processing....");
        }

        return counters.stream().mapToLong(CounterThread::getCount).sum();
    }

}
