package org.PrimeProj.ParallelCounters;

//This class calculates the number of prime numbers using CounterRunnable and conventional thread
//start and join mechanisms.

import org.PrimeProj.Counters.CounterRunnable;
import org.PrimeProj.Worker.WorkPartitioner;

import java.util.ArrayList;
import java.util.List;

public class ParallelCounter1 {
    public static long countPrimes(int rangeStart, int rangeFinish, int threadCount) {

        List<CounterRunnable> counters =  new ArrayList<>();
        int range = rangeFinish - rangeStart + 1;
        List<WorkPartitioner.Part> parts =  WorkPartitioner.partitions(range, threadCount);

        for (WorkPartitioner.Part part : parts) {
            counters.add(new CounterRunnable(part));
        }

        for (CounterRunnable counterRunnable : counters) {
            counterRunnable.startThread();
        }

        for (CounterRunnable counterRunnable : counters) {
            try {
                counterRunnable.joinThread();
            } catch (InterruptedException e) {
                System.err.println("Thread cannot join!");
            }
        }

        long count = 0;
        for (CounterRunnable counterRunnable : counters) {
            count += counterRunnable.getCount();
        }

        return count;
    }
}
