package org.PrimeProj.ParallelCounters;

//This class calculates the number of prime numbers using CounterThread and conventional thread
//start and join mechanisms.

import org.PrimeProj.Counters.CounterThread;
import org.PrimeProj.Worker.WorkPartitioner;

import java.util.ArrayList;
import java.util.List;

public class ParallelCounter0 {
    public static long countPrimes(int rangeStart, int rangeFinish, int threadCount) {

        List<CounterThread> counters =  new ArrayList<>();
        int range = rangeFinish - rangeStart + 1;
        List<WorkPartitioner.Part> parts =  WorkPartitioner.partitions(range, threadCount);

        for (WorkPartitioner.Part part : parts) {
            counters.add(new CounterThread(part));
        }

        for (CounterThread summerThread : counters) {
            summerThread.start();
        }

        for (CounterThread summerThread : counters) {
            try {
                summerThread.join();
            } catch (InterruptedException e) {
                System.err.println("Thread cannot join!");
            }
        }


        long count = 0;
        for (CounterThread counterThread : counters) {
            count += counterThread.getCount();
        }

        return count;
    }

}
