package org.PrimeProj.Counters;

import org.PrimeProj.Worker.WorkPartitioner;

public class CounterThread extends Thread{
    private int start;
    private int finish;
    private long count;

    public CounterThread( int start, int finish) {
        this.start = start;
        this.finish = finish;
    }

    public CounterThread(WorkPartitioner.Part part) {
        this(part.getStart(), part.getFinish());
    }

    public static boolean isPrime(int number) {
        if (number <= 1) return false;
        else if (number == 2) {
            return true;
        } else {
            for (int i = 2; i <= Math.sqrt(number); i++) {
                if (number % i == 0) return false;
            }
            return true;
        }
    }

    @Override
    public void run() {
        count = 0; // Update the class variable
        for(int i = start; i <= finish; i++) {
            if(isPrime(i)) {
                count++;
            }
        }
    }


    public long getCount() {
        return count;
    }
}
