import java.util.Random;


public class Main {

    public static final int MAX_PASSWORD = 9999;

    public static void main(String[] args) {
        Random random = new Random();
        int password = random.nextInt(MAX_PASSWORD + 1);
        Vault vault = new Vault(password);

        System.out.println("Cops on the way !!!");
        System.out.println("Password is: " + password);

        Thread ascendingHacker = new AscendingHackerThread(vault);
        ascendingHacker.setName("AscendingHacker");

        Thread descendingHacker = new DescendingHackerThread(vault);
        descendingHacker.setName("DescendingHacker");

        Thread police = new PoliceThread();
        police.setName("Cops");

        ascendingHacker.setPriority(Thread.MAX_PRIORITY);
        descendingHacker.setPriority(Thread.MAX_PRIORITY);

        ascendingHacker.start();
        descendingHacker.start();
        police.start();
    }


    static class Vault {
        private int password;

        public Vault(int password) {
            this.password = password;
        }

        public boolean isCorrectPassword(int guess) {
            try {
                Thread.sleep(5);
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
            return guess == this.password;
        }
    }

    static abstract class HackerThread extends Thread {
        protected Vault vault;

        public HackerThread(Vault vault) {
            this.vault = vault;
        }

        @Override
        public void run() {
            hackVault();
        }

        protected abstract void hackVault();

        protected void win(int guess) {
            System.out.println("!!! " + this.getName() + " nailed it password was: " + guess + " !!!");
            System.exit(0);
        }
    }


    static class AscendingHackerThread extends HackerThread {

        public AscendingHackerThread(Vault vault) {
            super(vault);
        }

        @Override
        protected void hackVault() {
            for (int guess = 0; guess <= MAX_PASSWORD; guess++) {
                if (vault.isCorrectPassword(guess)) {
                    win(guess);
                }
            }
        }
    }

    static class DescendingHackerThread extends HackerThread {

        public DescendingHackerThread(Vault vault) {
            super(vault);
        }

        @Override
        protected void hackVault() {
            for (int guess = MAX_PASSWORD; guess >= 0; guess--) {
                if (vault.isCorrectPassword(guess)) {
                    win(guess);
                }
            }
        }
    }


    static class PoliceThread extends Thread {
        @Override
        public void run() {
            for (int i = 10; i > 0; i--) {
                try {
                    Thread.sleep(1000);
                } catch (InterruptedException e) {
                    e.printStackTrace();
                }
                System.out.println(i + " Seconds left..");
            }

            System.out.println(">>> Time is up <<<");
            System.exit(0);
        }
    }
}
