import junit.framework.TestCase;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class SyncListTest extends TestCase {

    public void testAddList(){

        SyncList syncList = new SyncList();
//        syncList.remove(Integer.MAX_VALUE);
        syncList.add(1);
        syncList.add(2);
        syncList.add(3);
        syncList.add(Integer.MIN_VALUE);
        syncList.add(3);
        System.out.println(syncList.contain(5));
        System.out.println(syncList.contain(2));
        syncList.remove(3);
    }

    public void testRandSeq() {
        RandomSeq randomSeq = new RandomSeq(0, 80_000);
        for (int i = 0; i < 10; i++) {
            System.out.print(randomSeq.next() + " ");
        }
    }

    public void helper(SortList list, String label, int numThreads, int randLen) {
        RandomSeq seq = new RandomSeq(0, 80_000);
        List<Thread> addThreads = new ArrayList<>();
        List<Thread> containThreads = new ArrayList<>();
        List<Thread> removeThreads = new ArrayList<>();

        for (int i = 0; i < numThreads; i++) {
            AddThread addThread = new AddThread(seq, randLen / numThreads, list);
            ContainThread containThread = new ContainThread(seq, randLen / numThreads, list);
            RemoveThread removeThread = new RemoveThread(seq, randLen / numThreads, list);
            Thread threadA = new Thread(addThread);
            addThreads.add(threadA);
            Thread threadC = new Thread(containThread);
            containThreads.add(threadC);
            Thread threadR = new Thread(removeThread);
            removeThreads.add(threadR);
        }



        // Add phase.
        long startA = System.currentTimeMillis();

        addThreads.stream().forEach(e -> e.start() );
        addThreads.stream().forEach(e -> {
            try {
                e.join();
            } catch (InterruptedException ex) {
                throw new RuntimeException(ex);
            }
        });
        long endA = System.currentTimeMillis() - startA;

        System.out.println("ADD "+label+" execution task: "+endA+" ms");

        long listLengthAfterAdds = list.length;
        System.out.println("Length of the list after adding: "+listLengthAfterAdds);

        String listIsSorted = list.checkSorted() ? "The List is sorted" : "The list is not sorted";
        System.out.println(listIsSorted);



        // Contain phase.
       long startC = System.currentTimeMillis();

       containThreads.stream().forEach(e -> e.start() );
       containThreads.stream().forEach(e -> {
           try {
               e.join();
           } catch (InterruptedException ex) {
               throw new RuntimeException(ex);
           }
       });
       long endC = System.currentTimeMillis() - startC;
       System.out.println("\nContain "+label+" execution task: "+endC+" ms");

       System.out.println("Counter of Success contain operations: "+list.conatinSuccess);
       System.out.println("Counter of Failure contain operations: "+list.conatinFailure);



       // Remove phase.
       long startR = System.currentTimeMillis();

       removeThreads.stream().forEach(e -> e.start() );
       removeThreads.stream().forEach(e -> {
           try {
               e.join();
           } catch (InterruptedException ex) {
               throw new RuntimeException(ex);
           }
       });
       long endR = System.currentTimeMillis() - startR;


       System.out.println("\nRemove "+label+" execution task: "+endR+" ms");

       long listLengthAfterRemove = list.length;
       System.out.println("Length of the list after removing: "+listLengthAfterRemove);

       listIsSorted = list.checkSorted() ? "The List is sorted" : "The list is not sorted";
       System.out.println(listIsSorted);

       System.out.println("Counter of Success remove operations: "+list.removeSuccess);
       System.out.println("Counter of Failure reomve operations: "+list.removeFailure);

    }

    public void testRun(){
        SyncList syncList = new SyncList();

        System.out.println("\n--- CASE 1: THREADS=8, LENGTH=20,000 ---\n");
        helper(syncList,"Synchronization", 8, 20000);
        System.out.println("=======================================\n");
        RWLockList rwLockList = new RWLockList();
        helper(rwLockList, "RWLock", 8, 20000);
        System.out.println("=======================================\n");
        LockList list = new LockList();
        helper(list,"Lock", 8, 20000);

        System.out.println("\n--- CASE 2: THREADS=8, LENGTH=40,000 ---\n");
        helper(new SyncList(), "Synchronization", 8, 40000);
        System.out.println("=======================================\n");
        helper(new RWLockList(), "RWLock", 8, 40000);
        System.out.println("=======================================\n");
        helper(new LockList(), "Lock", 8, 40000);
        System.out.println("=======================================\n");


        System.out.println("\n--- CASE 3: THREADS=2, LENGTH=10,000 ---\n");
        helper(new SyncList(), "Synchronization", 2, 10000);
        System.out.println("=======================================\n");
        helper(new RWLockList(), "RWLock", 2, 10000);
        System.out.println("=======================================\n");
        helper(new LockList(), "Lock", 2, 10000);
        System.out.println("=======================================\n");


        System.out.println("FINISHED benchmarking");
    }

    public void testRemoveGroup(){

        System.out.println("\n--- TESTING removeGroup ---");
        // We test RWLockList as requested by the assignment
        SortList list = new RWLockList();

        list.add(10);
        list.add(5);
        list.add(20);
        list.add(15);
        list.add(30);

        System.out.println("List before removeGroup:");
        list.printList();
        assertEquals(5L, list.length); // Check initial length

        Collection<Integer> itemsToRemove = Arrays.asList(5, 12, 15, 25);

        int removedCount = ((RWLockList) list).removeGroup(itemsToRemove);

        System.out.println("\nList after removeGroup:");
        list.printList();


        assertEquals("Should have removed 2 items", 2, removedCount);

        assertEquals("List length should be 3", 3L, list.length);

        assertTrue("List should still be sorted", list.checkSorted());

        assertFalse("Item 5 should be removed", list.contain(5));
        assertFalse("Item 15 should be removed", list.contain(15));

        assertTrue("Item 10 should still be present", list.contain(10));
        assertTrue("Item 20 should still be present", list.contain(20));
        assertTrue("Item 30 should still be present", list.contain(30));


        assertEquals("Remove success count should be 2", 2, list.removeSuccess);
        assertEquals("Remove failure count should be 2", 2, list.removeFailure);

        System.out.println("\nremoveGroup test passed.");
    }


}
