import junit.framework.TestCase;

import java.util.ArrayList;
import java.util.List;

public class SyncListTest extends TestCase {

    public void testAddList(){

        SyncList syncList = new SyncList();
//        syncList.remove(Integer.MAX_VALUE);
        syncList.add(1);
        syncList.add(2);
        syncList.add(3);
        syncList.add(Integer.MIN_VALUE);
        syncList.add(3);
        System.out.println(syncList.contain(5));
        System.out.println(syncList.contain(2));
        syncList.remove(3);
    }

    public void testRandSeq() {
        RandomSeq randomSeq = new RandomSeq(0, 80_000);
        for (int i = 0; i < 10; i++) {
            System.out.print(randomSeq.next() + " ");
        }
    }

    int randLen = 20_000;
   public void helper(SortList list, String label) {
        RandomSeq seq = new RandomSeq(0, 80_000);
        List<Thread> addThreads = new ArrayList<>();
        List<Thread> containThreads = new ArrayList<>();
        List<Thread> removeThreads = new ArrayList<>();

        for (int i = 0; i < 8; i++) {
            AddThread addThread = new AddThread(seq, randLen / 8, list);
            ContainThread containThread = new ContainThread(seq, randLen / 8, list);
            RemoveThread removeThread = new RemoveThread(seq, randLen / 8, list);
            Thread threadA = new Thread(addThread);
            addThreads.add(threadA);
            Thread threadC = new Thread(containThread);
            containThreads.add(threadC);
            Thread threadR = new Thread(removeThread);
            removeThreads.add(threadR);
        }



        // Add phase.
        long startA = System.currentTimeMillis();

        addThreads.stream().forEach(e -> e.start() );
        addThreads.stream().forEach(e -> {
            try {
                e.join();
            } catch (InterruptedException ex) {
                throw new RuntimeException(ex);
            }
        });
        long endA = System.currentTimeMillis() - startA;

        System.out.println("ADD "+label+" execution task: "+endA+" ms");

        long listLengthAfterAdds = list.length;
        System.out.println("Length of the list after adding: "+listLengthAfterAdds);

        String listIsSorted = list.checkSorted() ? "The List is sorted" : "The list is not sorted";
        System.out.println(listIsSorted);



        // Contain phase.
       long startC = System.currentTimeMillis();

       containThreads.stream().forEach(e -> e.start() );
       containThreads.stream().forEach(e -> {
           try {
               e.join();
           } catch (InterruptedException ex) {
               throw new RuntimeException(ex);
           }
       });
       long endC = System.currentTimeMillis() - startC;
       System.out.println("\nContain "+label+" execution task: "+endC+" ms");

       System.out.println("Counter of Success contain operations: "+list.conatinSuccess);
       System.out.println("Counter of Failure contain operations: "+list.conatinFailure);



       // Remove phase.
       long startR = System.currentTimeMillis();

       removeThreads.stream().forEach(e -> e.start() );
       removeThreads.stream().forEach(e -> {
           try {
               e.join();
           } catch (InterruptedException ex) {
               throw new RuntimeException(ex);
           }
       });
       long endR = System.currentTimeMillis() - startR;


       System.out.println("\nRemove "+label+" execution task: "+endR+" ms");

       long listLengthAfterRemove = list.length;
       System.out.println("Length of the list after removing: "+listLengthAfterRemove);

       listIsSorted = list.checkSorted() ? "The List is sorted" : "The list is not sorted";
       System.out.println(listIsSorted);

       System.out.println("Counter of Success remove operations: "+list.removeSuccess);
       System.out.println("Counter of Failure reomve operations: "+list.removeFailure);

    }

    public void testRun(){
        SyncList syncList = new SyncList();
        helper(syncList,"Synchronization");
        System.out.println("=======================================\n");
        RWLockList rwLockList = new RWLockList();
        helper(rwLockList, "RWLock");
        System.out.println("=======================================\n");
        LockList list = new LockList();
        helper(list,"Lock");
    }
}
