import java.util.Collection;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class RWLockList extends SortList {
    ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    public RWLockList() {
        super();
    }

    @Override
    public boolean add(Integer obj) {
        try {
            lock.writeLock().lock();

            Entry prev = this.head;
            Entry curr = prev.next;
            while (curr.object.compareTo(obj) < 0) {
                prev = curr;
                curr = prev.next;
            }
            if (curr.object.equals(obj) || prev.object.equals(obj)) {
                return false;
            } else {
                Entry newEntry = new Entry(obj);
                newEntry.next = curr;
                prev.next = newEntry;
                this.length++;
                return true;
            }
        } finally {
            lock.writeLock().unlock();
        }
    }

    @Override
    public boolean remove(Integer obj) {
        try {
            lock.writeLock().lock();
            Entry prev = this.head;
            Entry curr = prev.next;
            while (curr.object.compareTo(obj) < 0) {
                prev = curr;
                curr = prev.next;
            }
            if (curr.object.equals(obj)) {
                prev.next = curr.next;
                this.length--;
                removeSuccess++;
                return true;
            } else {
                removeFailure++;
                return false;
            }
        } finally {
            lock.writeLock().unlock();
        }

    }

    @Override
    public boolean contain(Integer obj) {
        try {
            lock.readLock().lock();
            Entry prev = this.head;
            Entry curr = prev.next;
            while (curr.object.compareTo(obj) < 0) {
                prev = curr;
                curr = prev.next;
            }
            if (curr.object.equals(obj) || prev.object.equals(obj)) {
                conatinSuccess++;
                return true;
            } else {
                conatinFailure++;
                return false;
            }
        } finally {
            lock.readLock().unlock();
        }
    }

    public int removeGroup(Collection<Integer> items) {
        lock.writeLock().lock();
        int internalSuccess = 0;
        try {
            for (Integer item : items) {
                Entry prev = this.head;
                Entry curr = prev.next;
                while (curr.object.compareTo(item) < 0) {
                    prev = curr;
                    curr = prev.next;
                }
                if (curr.object.equals(item)) {
                    prev.next = curr.next;
                    this.length--;
                    internalSuccess++;
                }
            }

            this.removeSuccess+=internalSuccess;
            this.removeFailure+=items.size() - internalSuccess;

        } finally {
            lock.writeLock().unlock();
        }
        return internalSuccess;
    }

}
