
import Service.NumOfOccurrences;
import junit.framework.TestCase;
import java.util.Random;
import java.util.concurrent.ForkJoinPool;


public class NumOfOccurrencesTest extends TestCase {

    Random rand = new Random();
    int num=919;

    int size = 1000_000_000;


    private int[] randomArray(int size) {
        long s = 115;
        rand.setSeed(s);
        int[] arr = new int[size];
        for (int i = 0; i < size; i++) {
            arr[i] = (rand.nextInt(100000)+1);
        }
        return arr;
    }

    public void testNumOfOccurrencesSeq() {

        int[] arr = randomArray(size);

        NumOfOccurrences array = new NumOfOccurrences(arr, num,0, arr.length - 1);

        long start = System.currentTimeMillis();
        long occur = array.computeSeq();
        long endTimer = System.currentTimeMillis() - start;
        System.out.printf("Sequential Time execution for Random Array of size %d is %d ms,the number of occurrences of %d in Array is %d\n", size, endTimer, num,
                occur);
    }

    public void testNumOfOccurrencesPP() {
        System.setProperty("java.util.concurrent.ForkJoinPool.common.parallelism","7");

        int[] arr = randomArray(size);

        NumOfOccurrences array = new NumOfOccurrences(arr, num,0, arr.length - 1);
        long start = System.currentTimeMillis();
        ForkJoinPool.commonPool().invoke(array);
        long endTimer = System.currentTimeMillis() - start;
        System.out.printf("Parallel Time execution for Random Array of size %d is %d ms, the number of occurrences of %d in Array is %d\n", size, endTimer, num,
                array.occur);
    }


    public void testComputeStream(){
        System.setProperty("java.util.concurrent.ForkJoinPool.common.parallelism","7");

        int[] arr = randomArray(size);

        NumOfOccurrences array = new NumOfOccurrences(arr, num,0, arr.length - 1);
        long start = System.currentTimeMillis();
        array.computeStream();
        long endTimer = System.currentTimeMillis() - start;
        System.out.printf("Sequential Stream Time execution for Random Array of size %d is %d ms, the number of occurrences of %d in Array is %d\n", size, endTimer, num,
                array.occur);

    }

    public void testComputeParallelStream(){
        System.setProperty("java.util.concurrent.ForkJoinPool.common.parallelism","7");

        int[] arr = randomArray(size);

        NumOfOccurrences array = new NumOfOccurrences(arr, num,0, arr.length - 1);
        long start = System.currentTimeMillis();
        array.computeParallelStream();
        long endTimer = System.currentTimeMillis() - start;
        System.out.printf("Parallel Stream Time execution for Random Array of size %d is %d ms, the number of occurrences of %d in Array is %d\n", size, endTimer, num,
                array.occur);

    }


}
