package Service;
import java.util.Arrays;
import java.util.concurrent.RecursiveAction;

public class NumOfOccurrences extends RecursiveAction{

    public long occur=0;

    int arr[], num,lo, hi;

    public NumOfOccurrences(int[] arr, int num, int lo, int hi) {
        this.arr = arr;
        this.num = num;
        this.lo=lo;
        this.hi=hi;
    }

    public long computeSeq() {

        for (int i = lo; i <= hi; ++i) {
            if (arr[i]==num)
                occur++;
        }
        return occur;
    }

    @Override
    protected void compute() {
        if (hi - lo > 125000000) {
            int mid = (lo + hi) / 2;
            NumOfOccurrences left = new NumOfOccurrences (arr,num, lo, mid);
            NumOfOccurrences right = new NumOfOccurrences (arr,num ,mid + 1, hi);
            left.fork();
            right.compute();
            left.join();
            occur = left.occur + right.occur;
        } else {
            occur =computeSeq();
        }
    }

    public void computeParallelStream() {
        occur = Arrays.stream(arr).asLongStream().parallel().filter(a->a==num).count();
    }

    public void computeStream() {
        occur = Arrays.stream(arr).asLongStream().filter(a->a==num).count();
    }
}
