package Server;

import java.io.Serializable;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;

public class CalculatorImpl  extends UnicastRemoteObject implements ICalculator, Serializable {
    public CalculatorImpl() throws RemoteException {
        super();
    }

    @Override
    public int add(int a, int b) {
        System.out.println("add operation");
        return a + b;
    }

    @Override
    public int subtract(int a, int b) {
        System.out.println("subtract operation");

        return a - b;
    }

    @Override
    public int multiply(int a, int b) {
        System.out.println("multiply operation");

        return a * b;
    }

    @Override
    public double divide(int a, int b) throws RemoteException {
        System.out.println("divide operation");

        if (b == 0) throw new ArithmeticException("Cannot divide by zero");
        return (double) a / b;
    }
}