import Client.IProductClient;
import Server.ICalculator;
import Server.IServer;
import Server.Product;

import java.io.Serializable;
import java.net.MalformedURLException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;

//TIP To <b>Run</b> code, press <shortcut actionId="Run"/> or
// click the <icon src="AllIcons.Actions.Execute"/> icon in the gutter.
public class Main extends UnicastRemoteObject implements IProductClient, Serializable {
    protected Main() throws RemoteException {
    }

    public static void main(String[] args) throws MalformedURLException, NotBoundException, RemoteException {
        IServer iserver = (IServer) Naming.lookup("rmi://localhost:5099/ProductServer");

        ArrayList<Product> products =  iserver.getProducts();

        for (Product product: products ) {
            System.out.println(product.getId());
            System.out.println(product.getName());
            System.out.println(product.getSku());
            System.out.println(product.getDescription());

        }

        ICalculator calculator = (ICalculator) Naming.lookup("rmi://localhost:5099/CalculatorService");
        System.out.println("Addition: " + calculator.add(5, 3));
        System.out.println("Subtraction: " + calculator.subtract(5, 3));
        System.out.println("Multiplication: " + calculator.multiply(5, 3));
        System.out.println("Division: " + calculator.divide(5, 3));
    }
}