import Server.CalculatorImpl;
import Server.ICalculator;
import Server.ServerApp;

import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;


public class Main {
    public static void main(String[] args) throws RemoteException,RuntimeException {
        System.setProperty("java.security.policy","./ServerPolicy.policy");
        Registry registry = LocateRegistry.createRegistry(5099);
        registry.rebind("ProductServer",new ServerApp());
        System.out.println("Product Service is running...");

        ICalculator calculator = new CalculatorImpl();
        registry.rebind("CalculatorService", calculator);
        System.out.println("Calculator Service is running...");

    }
}