package task;

// 1. يجب أن يكون في نفس الباكج 'task'
// 2. يجب أن يرث من 'TaskImpl'
public class TaskPrimeCounter extends TaskImpl {

    // 3. كل ما نحتاجه هو كتابة دالة 'execute'
    @Override
    public void execute() {
        try {
            // 4. نقرأ المدخلات من المتغير 'input' (الذي ورثناه)
            int n = Integer.parseInt(input);

            // 5. نقوم بتشغيل اللوجيك الخاص بنا
            int count = countPrimes(n);

            // 6. نخزن النتيجة في المتغير 'result' (الذي ورثناه)
            this.result = "Found " + count + " prime (s) up to " + n;

        } catch (NumberFormatException e) {
            this.result = "Error: Input must be a valid number (e.g., 10000)";
        }
    }

    /**
     * دالة مساعدة لعد الأعداد الأولية حتى n
     */
    private int countPrimes(int n) {
        if (n <= 1) {
            return 0;
        }
        int counter = 0;
        for (int i = 2; i <= n; i++) {
            if (isPrime(i)) {
                counter++;
            }
        }
        return counter;
    }

    /**
     * دالة مساعدة لفحص إذا كان الرقم أولي
     */
    private boolean isPrime(int num) {
        if (num <= 1) return false;
        for (int i = 2; i * i <= num; i++) {
            if (num % i == 0) {
                return false;
            }
        }
        return true;
    }
}