package org.example;

import java.io.*;
import java.nio.file.*;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;

public class WriterConsumer implements Runnable {
    private final BlockingQueue<String> queue;
    private final String outputFile;
    private int writtenCount = 0;

    public WriterConsumer(BlockingQueue<String> queue, String outputFile) {
        this.queue = queue;
        this.outputFile = outputFile;
    }

    @Override
    public void run() {
        System.out.println("Writer: He started writing in " + outputFile);

        try (BufferedWriter writer = Files.newBufferedWriter(Paths.get(outputFile))) {
            while (true) {
                String processedLine = queue.poll(1, TimeUnit.SECONDS);

                if (processedLine != null) {
                    writer.write(processedLine);
                    writer.newLine();
                    writer.flush();

                    writtenCount++;
                    System.out.println(" Writer: He wrote the line " + writtenCount + " - " +
                            shortenText(processedLine, 30));

                    Thread.sleep(50);

                } else if (Main.isProducerFinished() &&
                        Main.getActiveWorkers().get() == 0 &&
                        queue.isEmpty()) {
                    break;
                }
            }

        } catch (IOException e) {
            System.err.println("Writer error: " + e.getMessage());
        } catch (InterruptedException e) {
            System.err.println("Writer: He was interrupted");
            Thread.currentThread().interrupt();
        }

        System.out.println("Writer: He finished writing " + writtenCount + " line in " + outputFile);
    }

    private String shortenText(String text, int maxLength) {
        if (text.length() <= maxLength) {
            return text;
        }
        return text.substring(0, maxLength) + "...";
    }
}