package org.example;

import java.io.*;
import java.nio.file.*;
import java.util.concurrent.BlockingQueue;

public class Producer implements Runnable {
    private final BlockingQueue<String> queue;
    private final String inputFile;

    public Producer(BlockingQueue<String> queue, String inputFile) {
        this.queue = queue;
        this.inputFile = inputFile;
    }

    @Override
    public void run() {
        System.out.println(" Product: Started reading the file " + inputFile);
        int lineCount = 0;

        try (BufferedReader reader = Files.newBufferedReader(Paths.get(inputFile))) {
            String line;

            while ((line = reader.readLine()) != null) {
                if (!line.trim().isEmpty()) {

                    queue.put(line);
                    lineCount++;
                    System.out.println("Producer: added the line" + lineCount + " - " +
                            shortenText(line, 40));


                    Thread.sleep(50);
                }
            }

        } catch (IOException e) {
            System.err.println("Product error while reading: " + e.getMessage());
        } catch (InterruptedException e) {
            System.err.println(" Product: interrupted");
            Thread.currentThread().interrupt();
        } finally {

            Main.setProducerFinished(true);
            System.out.println("Product: finished reading" + lineCount + " line");
        }
    }

    private String shortenText(String text, int maxLength) {
        if (text.length() <= maxLength) {
            return text;
        }
        return text.substring(0, maxLength) + "...";
    }
}