package org.example.Quiz.Client;

import org.example.Quiz.Shared.IQuizClient;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.List;


public class QuizClientImpl extends UnicastRemoteObject implements IQuizClient {

    public QuizClientImpl() throws RemoteException {
        super();
    }

    @Override
    public void notifyLeaderboardUpdate(List<String> leaderboard) throws RemoteException {
        System.out.println("\\n\\n==== Update the leaderboard ===");
        if (leaderboard.isEmpty()) {
            System.out.println(" (There are no leaderboards currently)");
        } else {
            for (String entry : leaderboard) {
                System.out.println("   " + entry);
            }
        }
        System.out.println("==============================\n");
        System.out.print("Select (1: Ask a question, 2: Send an answer): ");
    }
}