package org.example.Quiz.Client;

import org.example.Quiz.Shared.IQuizClient;
import org.example.Quiz.Shared.IQuizServer;

import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.Scanner;

public class Client {

    private static String currentQuestion = "";

    public static void main(String[] args) {
        try {
            Registry registry = LocateRegistry.getRegistry("localhost", 1099);

            IQuizServer serverStub = (IQuizServer) registry.lookup("QuizService");

            IQuizClient clientCallbackObject = new QuizClientImpl();

            Scanner scanner = new Scanner(System.in, "UTF-8");
            System.out.print("Please enter your name:");
            String studentName = scanner.nextLine();

            serverStub.registerClient(clientCallbackObject, studentName);
            System.out.println("...Registered successfully, " + studentName + "!");

            String choice = "";
            while (true) {
                System.out.println("\n---Options menu---");
                System.out.println("1. Request a new question");
                System.out.println("2. Submit an answer");
                System.out.println("Type 'exit' to exit the program");
                System.out.print("Choose (1 or 2): ");

                choice = scanner.nextLine();

                if (choice.equalsIgnoreCase("Exit")) {
                    break;
                }

                switch (choice) {
                    case "1":
                        currentQuestion = serverStub.getQuestion(studentName);
                        System.out.println("\n>>> New question: " + currentQuestion);
                        break;
                    case "2":
                        if (currentQuestion.isEmpty()) {
                            System.out.println("!!! You must ask a question first (option 1)");
                            continue;
                        }
                        System.out.print(">>> Enter your answer to the question: ");
                        String answer = scanner.nextLine();

                        String feedback = serverStub.submitAnswer(studentName, answer);

                        System.out.println("\n--- Answer result---");
                        System.out.println(feedback);

                        currentQuestion = "";
                        break;
                    default:
                        System.out.println("!!! Wrong selection, please enter 1 or 2.");
                        break;
                }
            }

            System.out.println("Thank you ");
            System.exit(0);

        } catch (Exception e) {
            System.err.println("!!! A client error occurred!!!");
            if (e instanceof java.rmi.NotBoundException) {
                System.err.println("!!! The server (QuizService) cannot be found. Is the server running?");
            }
            e.printStackTrace();
        }
    }
}