package org.example.Quiz.Server;

import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;

public class Server {
    public static void main(String[] args) {
        try {
            QuizServerImpl quizServer = new QuizServerImpl();

            Registry registry = LocateRegistry.createRegistry(1099);

            registry.rebind("QuizService", quizServer);

            System.out.println("===================================");
            System.out.println("  >>> Quiz Server is Ready <<<  ");
            System.out.println("... Waiting for client connections on port 1099");
            System.out.println("===================================");

        } catch (Exception e) {
            System.err.println("!!! An error occurred while running the Server !!!");
            e.printStackTrace();
        }
    }
}