package org.example.Quiz.Server;


import org.example.Quiz.Client.QuizClientImpl;
import org.example.Quiz.Shared.IQuizClient;
import org.example.Quiz.Shared.IQuizServer;

import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;


public class QuizServerImpl extends UnicastRemoteObject implements IQuizServer {


    private final Map<String, String> questions;


    private final Map<String, Integer> studentScores;


    private final Map<String, IQuizClient> connectedClients;


    public QuizServerImpl() throws RemoteException {
        super();


        questions = new ConcurrentHashMap<>();
        studentScores = new ConcurrentHashMap<>();
        connectedClients = new ConcurrentHashMap<>();


        questions.put("What is the capital of Jordan?", "Amman");
        questions.put("How many continents are there in the world?", "7");
        questions.put("What color is the sky on a clear day?", "blue");
        questions.put("2 + 2 = ?", "4");
    }


    @Override
    public void registerClient(IQuizClient clientStub, String studentName) throws RemoteException {
        System.out.println("...New customer registration: " + studentName);

        studentScores.put(studentName, 0);

        connectedClients.put(studentName, clientStub);

        System.out.println("... has been registered " + studentName + ". Number of clients now: " + connectedClients.size());

        updateAndNotifyLeaderboard();
    }

    @Override
    public void registerClient(QuizClientImpl clientStub, String studentName) throws RemoteException {

    }

    @Override
    public String getQuestion(String studentName) throws RemoteException {
        System.out.println("... Student " + studentName + "He asks a question");


        List<String> questionList = new ArrayList<>(questions.keySet());


        Collections.shuffle(questionList);


        return questionList.get(0);
    }

    @Override
    public String submitAnswer(String studentName, String answer) throws RemoteException {
        System.out.println("...student" + studentName + "Send answer:" + answer);


        String correctAnswer = questions.get("What is the capital of Jordan?");

        boolean isCorrect = false;
        if (questions.containsValue(answer.trim())) {
            isCorrect = true;
        }

        if (isCorrect) {

            int currentScore = studentScores.get(studentName);
            studentScores.put(studentName, currentScore + 1);


            updateAndNotifyLeaderboard();

            return "Correct answer! Your current score is: " + (currentScore + 1);
        } else {

            return "Wrong answer. Try again.";
        }
    }




    private void updateAndNotifyLeaderboard() {
        System.out.println("...The leaderboard is being updated...");


        List<Map.Entry<String, Integer>> sortedScores = new ArrayList<>(studentScores.entrySet());


        sortedScores.sort((o1, o2) -> o2.getValue().compareTo(o1.getValue()));


        List<String> leaderboard = new ArrayList<>();
        int count = 0;
        for (Map.Entry<String, Integer> entry : sortedScores) {
            if (count >= 3) break;

            leaderboard.add((count + 1) + ". " + entry.getKey() + " (" + entry.getValue() + " point)");
            count++;
        }


        System.out.println("... Send notice to " + connectedClients.size() + " client");

        for (IQuizClient client : connectedClients.values()) {
            try {
                client.notifyLeaderboardUpdate(leaderboard);
            } catch (RemoteException e) {

                System.err.println("...Error sending a notification to a client: " + e.getMessage());

            }
        }
    }
}