import grpc
from concurrent import futures
import time

# Import the files we generated
import calculator_pb2
import calculator_pb2_grpc

# Specify the name of the log file
LOG_FILE = "addition_log.txt"


#Inherit must inherit from the class generated in the _grpc.py file
class AdditionService(calculator_pb2_grpc.AdditionServiceServicer):

    #2. Apply the Add function
    def Add(self, request, context):
        print(f"Received Add request: num1={request.num1}, num2={request.num2}")


        result = request.num1 + request.num2
        log_message = f"Add Operation: {request.num1} + {request.num2} = {result}\n"

        # --- Recording the operation in the log ---
        try:
            with open(LOG_FILE, "a") as f:
                f.write(log_message)
        except Exception as e:
            print(f"Failed to write to log: {e}")

      # Return the response (must be of type OperationResponse)
        return calculator_pb2.OperationResponse(result=result)

   #3. Implement the log broadcast function (GetAdditionLog)
    def GetAdditionLog(self, request, context):
        print("Received GetLog request. Streaming log...")

        try:
            #Open the log file for reading
            with open(LOG_FILE, "r") as f:
                # Read line by line
                for line in f:
                    #Send each line as a "stream" to the client
                    yield calculator_pb2.LogEntry(message=line.strip())

                    time.sleep(0.1)

        except FileNotFoundError:
            print("Log file not found.")
            # Sending one error message
            yield calculator_pb2.LogEntry(message="Log file not found.")
        except Exception as e:
            print(f"Error reading log file: {e}")
            yield calculator_pb2.LogEntry(message=f"Error reading log file: {e}")

#4. The main function to operate the server
def serve():
    # Create a server with 10 threads
    server = grpc.server(futures.ThreadPoolExecutor(max_workers=10))

    #Add our service to the server
    calculator_pb2_grpc.add_AdditionServiceServicer_to_server(AdditionService(), server)

    #Select the port
    port = "50051"
    server.add_insecure_port(f"[::]:{port}")

    server.start()
    print(f"Addition Service server started on port {port}...")

    #Keep the server running
    try:
        while True:
            time.sleep(86400) #1 day (to keep the main thread alive)
    except KeyboardInterrupt:
        print("Stopping server...")
        server.stop(0)


if __name__ == "__main__":
    serve()